<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

// CONFIG
// CREDENTIALS
$ADMIN_USER = 'strike';
$ADMIN_PASS = 'xxxxx';

// FILES
$OPERATORS_FILE = __DIR__ . '/../data/operators.json';

// INIT FILES
if (!dir(dirname($OPERATORS_FILE)))
    mkdir(dirname($OPERATORS_FILE), 0777, true);
if (!file_exists($OPERATORS_FILE))
    file_put_contents($OPERATORS_FILE, '{}');

$data = json_decode(file_get_contents('php://input'), true) ?? [];
$action = $_GET['action'] ?? ($data['action'] ?? '');

if ($action === 'login') {
    $user = $data['user'] ?? '';
    $pass = $data['pass'] ?? '';

    if ($user === $ADMIN_USER && $pass === $ADMIN_PASS) {
        // Success: Create Session
        $token = bin2hex(random_bytes(16));
        $operators = json_decode(file_get_contents($OPERATORS_FILE), true);

        $operators[$token] = [
            'name' => $user,
            'ip' => $_SERVER['REMOTE_ADDR'],
            'login_time' => time(),
            'last_seen' => time(),
            'token' => $token
        ];

        file_put_contents($OPERATORS_FILE, json_encode($operators));

        echo json_encode(['success' => true, 'token' => $token, 'name' => $user]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Credenciales incorrectas']);
    }

} elseif ($action === 'heartbeat') {
    $token = $data['token'] ?? '';
    $operators = json_decode(file_get_contents($OPERATORS_FILE), true);

    if (isset($operators[$token])) {
        $operators[$token]['last_seen'] = time();
        file_put_contents($OPERATORS_FILE, json_encode($operators));
        echo json_encode(['success' => true, 'status' => 'active']);
    } else {
        // Token not found = KICKED or LOGGED OUT
        echo json_encode(['success' => false, 'status' => 'kicked']);
    }

} elseif ($action === 'get_operators') {
    $operators = json_decode(file_get_contents($OPERATORS_FILE), true);

    // Clean stale sessions (> 1 min inactivity)
    $now = time();
    $active = [];
    foreach ($operators as $t => $op) {
        if ($now - $op['last_seen'] < 60) {
            $active[] = [
                'name' => $op['name'],
                'ip' => $op['ip'],
                'token' => $op['token'], // Needed for kick
                'time' => date('H:i:s', $op['login_time'])
            ];
        } else {
            unset($operators[$t]);
        }
    }
    file_put_contents($OPERATORS_FILE, json_encode($operators));

    echo json_encode(['success' => true, 'operators' => $active]);

} elseif ($action === 'kick_operator') {
    $target_token = $data['target_token'] ?? '';
    $operators = json_decode(file_get_contents($OPERATORS_FILE), true);

    if (isset($operators[$target_token])) {
        unset($operators[$target_token]);
        file_put_contents($OPERATORS_FILE, json_encode($operators));
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Not found']);
    }
}
?>