<?php
// download.php - Securely download registros.txt

// CONFIG
$FILE = __DIR__ . '/../data/registros.txt';
$OPERATORS_FILE = __DIR__ . '/../data/operators.json';

// GET Token
$token = $_GET['token'] ?? '';

if (empty($token)) {
    die("Acceso denegado (No token)");
}

// Verify Token
$operators = json_decode(file_get_contents($OPERATORS_FILE), true) ?? [];

if (!isset($operators[$token])) {
    die("Acceso denegado (Token inválido)");
}

// Check File
if (!file_exists($FILE)) {
    die("No hay registros aún.");
}

// Servir Archivo
header('Content-Description: File Transfer');
header('Content-Type: application/octet-stream');
header('Content-Disposition: attachment; filename="registros.txt"');
header('Expires: 0');
header('Cache-Control: must-revalidate');
header('Pragma: public');
header('Content-Length: ' . filesize($FILE));
readfile($FILE);
exit;
?>